;; This example shows a CPC+ hardware sprite.
;;
;; This example is designed for CPC+ only and will
;; not work on CPC or KC Compact.
;;
;;
;; This example will compile with the MAXAM assembler
;; or the built-in assembler of WinAPE32.


;; NOTE - For this example to work, the code must not
;; be in the range &4000-&7fff inclusive. The ASIC registers
;; are paged into this range, and the code would not be
;; visible to the CPU if it was also in this range.
org &8000


;;--------------------------------------------------
;; STEP 1 - Unlock CPC+ additional features
;; unlock asic to gain access to asic registers

di
ld b,&bc
ld hl,sequence
ld e,17
.seq 
ld a,(hl)
out (c),a
inc hl
dec e
jr nz,seq
ei

;;--------------------------------------------------
;; STEP 2 - Setup sprite pixel data
;;
;; The ASIC has internal "RAM" used to store the sprite pixel
;; data. If you want to change the pixel data for a sprite
;; then you need to copy new data into the internal "RAM".

;; page-in asic registers to &4000-&7fff
ld bc,&7fb8
out (c),c

;; stored sprite pixel data
ld hl,sprite_pixel_data

;; address of sprite 0 pixel data
;; sprite 0 pixel data is in the range &4000-&4100
ld de,&4000

;; length of pixel data for a single sprite (16x16 = 256)
ld bc,&100
ldir

;; page-out asic registers
ld bc,&7fa0
out (c),c

;;--------------------------------------------------
;; STEP 3 - Setup sprite palette
;;
;; The sprites use a single 15 entry sprite palette.
;; pen 0 is ALWAYS transparent.
;;
;; The sprite palette is different to the screen palette.

;; page-in asic registers to &4000-&7fff
ld bc,&7fb8
out (c),c

;; copy colours into ASIC sprite palette registers
ld hl,sprite_colours
ld de,&6422
ld bc,15*2
ldir

;; page-out asic registers
ld bc,&7fa0
out (c),c

;;--------------------------------------------------
;; STEP 4 - Setup sprite properties
;;
;; Each sprite has properties which define the x,y coordinates 
;; and x,y magnification.

;; page-in asic registers to &4000-&7fff
ld bc,&7fb8
out (c),c


;; set x coordinate for sprite 0
ld hl,100
ld (&6000),hl

;; set y coordinate for sprite 0
ld hl,100
ld (&6002),hl

;; set sprite x and y magnification
;; x magnification = 1
;; y magnification = 1
ld a,%0101
ld (&6004),a


;; page-out asic registers
ld bc,&7fa0
out (c),c

;;--------------------------------------------------
ret


;;--------------------------------------------------
;; - there is two bytes per colour.
;; - these are stored in a form that can be written direct 
;; to the CPC+ colour palette registers (i.e. xGRB)
;; - pen 0 is always transparent and doesn't have a entry
;; in the CPC+ palette

.sprite_colours
defw &0111			;; colour for sprite pen 1
defw &0222			;; colour for sprite pen 2
defw &0333			;; colour for sprite pen 3
defw &0444			;; colour for sprite pen 4
defw &0555			;; colour for sprite pen 5
defw &0666			;; colour for sprite pen 6
defw &0777			;; colour for sprite pen 7
defw &0888			;; colour for sprite pen 8
defw &0999			;; colour for sprite pen 9
defw &0aaa			;; colour for sprite pen 10
defw &0bbb			;; colour for sprite pen 11
defw &0ccc			;; colour for sprite pen 12
defw &0ddd			;; colour for sprite pen 13
defw &0eee			;; colour for sprite pen 14
defw &0fff			;; colour for sprite pen 15

;;---------------------------------------------
;; - there is one pixel per byte (bits 3..0 of each byte define the palette index for this pixel)
;; - these bytes are stored in a form that can be written direct to the ASIC
;; sprite pixel data
.sprite_pixel_data
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 0
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 1
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 2
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 3
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 4
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 5
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 6
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 7
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 8
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 9
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 10
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 11
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 12
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 13
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 14
defb &00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00,&00		;; line 15


;;----------------------------------------------------------
;; this is the sequence to unlock the ASIC extra features
.sequence
defb &ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee